
import java.awt.*;
import java.util.StringTokenizer;


public class jumping extends java.applet.Applet implements Runnable {
    Thread blinker;
    String message;
    Font font;
    int speed;

    public void init() {
	font = new java.awt.Font("TimesRoman", Font.ITALIC, 48);
	String att = getParameter("speed");
	speed = (att == null) ? 400 : (1000 / Integer.valueOf(att).intValue());
	att = getParameter("message");
	message = (att == null) ? "Blink" : att;
    }

    public void paint(Graphics g) {
        setBackground(new Color(200, 250, 250));

	int x = 20, y = font.getSize(), space;
	int red = (int)(Math.random() * 50);
	int green = (int)(Math.random() * 50);
	int blue = (int)(Math.random() * 256);
	Dimension d = size();

	g.setColor(Color.black);
	g.setFont(font);
	FontMetrics fm = g.getFontMetrics();
	space = fm.stringWidth(" ");
	for (StringTokenizer t = new StringTokenizer(message) ; t.hasMoreTokens() ; ) {
	    String word = t.nextToken();
	    int w = fm.stringWidth(word) + space;
	    if (x + w > d.width) {
		x = 20;
		y += font.getSize();
	    }
	    if (Math.random() < 0.5) {
		g.setColor(new java.awt.Color((red + y * 30) % 256, (green + x / 3) % 256, blue));
	    } else {
                g.setColor(getBackground());
	    }
	    g.drawString(word, x, y);
	    x += w;
	}
    }

    public void start() {
	blinker = new Thread(this);
	blinker.start();
    }
    public void stop() {
	blinker.stop();
    }
    public void run() {
	while (true) {
	try {Thread.currentThread().sleep(speed);} catch (InterruptedException e){}
	    repaint();
	}
    }
}
