/*
* Copyright (c) 1994-1998 Sun Microsystems, Inc. All Rights Reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for NON-COMMERCIAL or COMMERCIAL purposes and without fee is
* hereby granted. Please refer to the file
* http://java.sun.com/nav/business/trademark_guidelines.html for further
* important copyright and trademark information and to
* http://java.sun.com/nav/business/index.html for further important licensing
* information for the Java (tm) Technology.
* 
* SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
* NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
* LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
* ITS DERIVATIVES.
* 
* THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
* CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE PERFORMANCE,
* SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT NAVIGATION OR
* COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE SUPPORT MACHINES, OR
* WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE SOFTWARE COULD LEAD DIRECTLY TO
* DEATH, PERSONAL INJURY, OR SEVERE PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH
* RISK ACTIVITIES"). SUN SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED
* WARRANTY OF FITNESS FOR HIGH RISK ACTIVITIES.
*/

import java.awt.*;

public class Sprite extends Object
{
   private Dimension size;

   private int frame;
   private int num;
   private int x[];
   private int dx[];

   private int loop;
   private int inc;
   private int count = 0;

   // Constructor for the Sprite class.

   public Sprite(int n, Dimension s, int l)
   {
      num = n;
      size = s;
      frame = 0;

      // Allocate space for x and dx arrays.

      x = new int[n];
      dx = new int[n];

      // Initialize the x and dx array values.

      for (int i = 0; i < n; i++)
      {
         x[i] = size.width + (i * size.width);
         dx[i] = -x[i];
      }

      // Set the number of times to loop.

      if (l > 0)
      {
         loop = l;
         inc = 1;
      }

      else
      {
         loop = 1;
         inc = 0;
      }
   }

   public void draw(Graphics g)
   {
      g.copyArea(x[frame], 0, size.width, size.height, dx[frame], 0);

      if (count < loop)
      {
         frame++;

         if (frame >= num)
         {
            count += inc;

            if (count != loop)
            {
               frame = 0; 
            }

            // Reset to the last frame since at end of loop.

            else
            {
               frame = num - 1; 
            }
         }
      }
   }
}
